export type AIStatus = 'none' | 'processing' | 'completed' | 'failed';
export type EnhancementType = 'beautify' | 'svg';

export interface Sketch {
  id: string;
  vendor_id: string;
  customer_id?: string;
  invoice_id?: string;
  file_url: string;
  ai_status: AIStatus;
  ai_output_url?: string;
  tags: string[];
  notes?: string;
  uploaded_at: string;
  enhancement_type?: EnhancementType;
}

export interface UploadSketchRequest {
  customer_id?: string;
  invoice_id?: string;
  tags?: string[];
  notes?: string;
}

export interface EnhanceSketchRequest {
  enhancement_type: EnhancementType;
} 